#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private SpeculatorSeth.spsAdvCumulativeDelta[] cachespsAdvCumulativeDelta;
		private SpeculatorSeth.spsAlice[] cachespsAlice;
		private SpeculatorSeth.spsCumulativeDelta[] cachespsCumulativeDelta;
		private SpeculatorSeth.spsDataPipe[] cachespsDataPipe;
		private SpeculatorSeth.spsDelta[] cachespsDelta;
		private SpeculatorSeth.spsFairValueGap[] cachespsFairValueGap;
		private SpeculatorSeth.spsInsideBidAsk[] cachespsInsideBidAsk;
		private SpeculatorSeth.spsInventoryCostBasis[] cachespsInventoryCostBasis;
		private SpeculatorSeth.spsKalman[] cachespsKalman;
		private SpeculatorSeth.spsLargestRestingOrders[] cachespsLargestRestingOrders;
		private SpeculatorSeth.spsLevel2Changes[] cachespsLevel2Changes;
		private SpeculatorSeth.spsMarketOrderImbalance[] cachespsMarketOrderImbalance;
		private SpeculatorSeth.spsMultiATR[] cachespsMultiATR;
		private SpeculatorSeth.spsNewsWarning[] cachespsNewsWarning;
		private SpeculatorSeth.spsProjectedRange[] cachespsProjectedRange;
		private SpeculatorSeth.spsPulledPrices[] cachespsPulledPrices;
		private SpeculatorSeth.spsRangeHistogram[] cachespsRangeHistogram;
		private SpeculatorSeth.spsRestingOrders[] cachespsRestingOrders;
		private SpeculatorSeth.spsRestingOrdersFiltered[] cachespsRestingOrdersFiltered;
		private SpeculatorSeth.spsScatterPlot[] cachespsScatterPlot;
		private SpeculatorSeth.spsSessionHighlight[] cachespsSessionHighlight;
		private SpeculatorSeth.spsSpread[] cachespsSpread;
		private SpeculatorSeth.spsVolatilityProjectedRange[] cachespsVolatilityProjectedRange;
		private SpeculatorSeth.spsVWAP[] cachespsVWAP;
		private SpeculatorSeth.spsYieldCurve[] cachespsYieldCurve;
		private SpeculatorSethFree.spsRangeHistogramFree[] cachespsRangeHistogramFree;

		
		public SpeculatorSeth.spsAdvCumulativeDelta spsAdvCumulativeDelta(SpSTimeframe resetDeltaOn)
		{
			return spsAdvCumulativeDelta(Input, resetDeltaOn);
		}

		public SpeculatorSeth.spsAlice spsAlice(int period, double target)
		{
			return spsAlice(Input, period, target);
		}

		public SpeculatorSeth.spsCumulativeDelta spsCumulativeDelta(SpsTimeframe resetDeltaOn)
		{
			return spsCumulativeDelta(Input, resetDeltaOn);
		}

		public SpeculatorSeth.spsDataPipe spsDataPipe(int startHour, int startMinute, int endHour, int endMinute, bool outputMarketDepth, bool outputMarketData)
		{
			return spsDataPipe(Input, startHour, startMinute, endHour, endMinute, outputMarketDepth, outputMarketData);
		}

		public SpeculatorSeth.spsDelta spsDelta()
		{
			return spsDelta(Input);
		}

		public SpeculatorSeth.spsFairValueGap spsFairValueGap(double gap, int dailyATRPeriod)
		{
			return spsFairValueGap(Input, gap, dailyATRPeriod);
		}

		public SpeculatorSeth.spsInsideBidAsk spsInsideBidAsk(bool saveData)
		{
			return spsInsideBidAsk(Input, saveData);
		}

		public SpeculatorSeth.spsInventoryCostBasis spsInventoryCostBasis(bool isCumulative, bool resetOn_Session)
		{
			return spsInventoryCostBasis(Input, isCumulative, resetOn_Session);
		}

		public SpeculatorSeth.spsKalman spsKalman(double gain)
		{
			return spsKalman(Input, gain);
		}

		public SpeculatorSeth.spsLargestRestingOrders spsLargestRestingOrders(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return spsLargestRestingOrders(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public SpeculatorSeth.spsLevel2Changes spsLevel2Changes(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return spsLevel2Changes(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public SpeculatorSeth.spsMarketOrderImbalance spsMarketOrderImbalance(int period)
		{
			return spsMarketOrderImbalance(Input, period);
		}

		public SpeculatorSeth.spsMultiATR spsMultiATR(int period, RangeType myRangeType)
		{
			return spsMultiATR(Input, period, myRangeType);
		}

		public SpeculatorSeth.spsNewsWarning spsNewsWarning(int beforeHalt, int afterHalt)
		{
			return spsNewsWarning(Input, beforeHalt, afterHalt);
		}

		public SpeculatorSeth.spsProjectedRange spsProjectedRange()
		{
			return spsProjectedRange(Input);
		}

		public SpeculatorSeth.spsPulledPrices spsPulledPrices(int gap, long size)
		{
			return spsPulledPrices(Input, gap, size);
		}

		public SpeculatorSeth.spsRangeHistogram spsRangeHistogram(bool useLog, bool useArea, double valueAreaPercent, bool limitByDayOfWeek, System.DayOfWeek week, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return spsRangeHistogram(Input, useLog, useArea, valueAreaPercent, limitByDayOfWeek, week, normalColor, valueColor, textSize, textColor);
		}

		public SpeculatorSeth.spsRestingOrders spsRestingOrders(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return spsRestingOrders(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public SpeculatorSeth.spsRestingOrdersFiltered spsRestingOrdersFiltered(bool saveData, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return spsRestingOrdersFiltered(Input, saveData, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public SpeculatorSeth.spsScatterPlot spsScatterPlot(int factor, Brush pointColor)
		{
			return spsScatterPlot(Input, factor, pointColor);
		}

		public SpeculatorSeth.spsSessionHighlight spsSessionHighlight(int startHour, int startMinute, int endHour, int endMinute)
		{
			return spsSessionHighlight(Input, startHour, startMinute, endHour, endMinute);
		}

		public SpeculatorSeth.spsSpread spsSpread(string leg0, int ratio0, string leg1, int ratio1, string leg2, int ratio2, string leg3, int ratio3, string leg4, int ratio4, bool userProvidesMonth, int number, bool grayHistorical)
		{
			return spsSpread(Input, leg0, ratio0, leg1, ratio1, leg2, ratio2, leg3, ratio3, leg4, ratio4, userProvidesMonth, number, grayHistorical);
		}

		public SpeculatorSeth.spsVolatilityProjectedRange spsVolatilityProjectedRange()
		{
			return spsVolatilityProjectedRange(Input);
		}

		public SpeculatorSeth.spsVWAP spsVWAP(SpsTimeframe resetDeltaOn)
		{
			return spsVWAP(Input, resetDeltaOn);
		}

		public SpeculatorSeth.spsYieldCurve spsYieldCurve(string expiry)
		{
			return spsYieldCurve(Input, expiry);
		}

		public SpeculatorSethFree.spsRangeHistogramFree spsRangeHistogramFree(double valueAreaPercent, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return spsRangeHistogramFree(Input, valueAreaPercent, normalColor, valueColor, textSize, textColor);
		}


		
		public SpeculatorSeth.spsAdvCumulativeDelta spsAdvCumulativeDelta(ISeries<double> input, SpSTimeframe resetDeltaOn)
		{
			if (cachespsAdvCumulativeDelta != null)
				for (int idx = 0; idx < cachespsAdvCumulativeDelta.Length; idx++)
					if (cachespsAdvCumulativeDelta[idx].ResetDeltaOn == resetDeltaOn && cachespsAdvCumulativeDelta[idx].EqualsInput(input))
						return cachespsAdvCumulativeDelta[idx];
			return CacheIndicator<SpeculatorSeth.spsAdvCumulativeDelta>(new SpeculatorSeth.spsAdvCumulativeDelta(){ ResetDeltaOn = resetDeltaOn }, input, ref cachespsAdvCumulativeDelta);
		}

		public SpeculatorSeth.spsAlice spsAlice(ISeries<double> input, int period, double target)
		{
			if (cachespsAlice != null)
				for (int idx = 0; idx < cachespsAlice.Length; idx++)
					if (cachespsAlice[idx].Period == period && cachespsAlice[idx].Target == target && cachespsAlice[idx].EqualsInput(input))
						return cachespsAlice[idx];
			return CacheIndicator<SpeculatorSeth.spsAlice>(new SpeculatorSeth.spsAlice(){ Period = period, Target = target }, input, ref cachespsAlice);
		}

		public SpeculatorSeth.spsCumulativeDelta spsCumulativeDelta(ISeries<double> input, SpsTimeframe resetDeltaOn)
		{
			if (cachespsCumulativeDelta != null)
				for (int idx = 0; idx < cachespsCumulativeDelta.Length; idx++)
					if (cachespsCumulativeDelta[idx].ResetDeltaOn == resetDeltaOn && cachespsCumulativeDelta[idx].EqualsInput(input))
						return cachespsCumulativeDelta[idx];
			return CacheIndicator<SpeculatorSeth.spsCumulativeDelta>(new SpeculatorSeth.spsCumulativeDelta(){ ResetDeltaOn = resetDeltaOn }, input, ref cachespsCumulativeDelta);
		}

		public SpeculatorSeth.spsDataPipe spsDataPipe(ISeries<double> input, int startHour, int startMinute, int endHour, int endMinute, bool outputMarketDepth, bool outputMarketData)
		{
			if (cachespsDataPipe != null)
				for (int idx = 0; idx < cachespsDataPipe.Length; idx++)
					if (cachespsDataPipe[idx].StartHour == startHour && cachespsDataPipe[idx].StartMinute == startMinute && cachespsDataPipe[idx].EndHour == endHour && cachespsDataPipe[idx].EndMinute == endMinute && cachespsDataPipe[idx].OutputMarketDepth == outputMarketDepth && cachespsDataPipe[idx].OutputMarketData == outputMarketData && cachespsDataPipe[idx].EqualsInput(input))
						return cachespsDataPipe[idx];
			return CacheIndicator<SpeculatorSeth.spsDataPipe>(new SpeculatorSeth.spsDataPipe(){ StartHour = startHour, StartMinute = startMinute, EndHour = endHour, EndMinute = endMinute, OutputMarketDepth = outputMarketDepth, OutputMarketData = outputMarketData }, input, ref cachespsDataPipe);
		}

		public SpeculatorSeth.spsDelta spsDelta(ISeries<double> input)
		{
			if (cachespsDelta != null)
				for (int idx = 0; idx < cachespsDelta.Length; idx++)
					if ( cachespsDelta[idx].EqualsInput(input))
						return cachespsDelta[idx];
			return CacheIndicator<SpeculatorSeth.spsDelta>(new SpeculatorSeth.spsDelta(), input, ref cachespsDelta);
		}

		public SpeculatorSeth.spsFairValueGap spsFairValueGap(ISeries<double> input, double gap, int dailyATRPeriod)
		{
			if (cachespsFairValueGap != null)
				for (int idx = 0; idx < cachespsFairValueGap.Length; idx++)
					if (cachespsFairValueGap[idx].Gap == gap && cachespsFairValueGap[idx].DailyATRPeriod == dailyATRPeriod && cachespsFairValueGap[idx].EqualsInput(input))
						return cachespsFairValueGap[idx];
			return CacheIndicator<SpeculatorSeth.spsFairValueGap>(new SpeculatorSeth.spsFairValueGap(){ Gap = gap, DailyATRPeriod = dailyATRPeriod }, input, ref cachespsFairValueGap);
		}

		public SpeculatorSeth.spsInsideBidAsk spsInsideBidAsk(ISeries<double> input, bool saveData)
		{
			if (cachespsInsideBidAsk != null)
				for (int idx = 0; idx < cachespsInsideBidAsk.Length; idx++)
					if (cachespsInsideBidAsk[idx].SaveData == saveData && cachespsInsideBidAsk[idx].EqualsInput(input))
						return cachespsInsideBidAsk[idx];
			return CacheIndicator<SpeculatorSeth.spsInsideBidAsk>(new SpeculatorSeth.spsInsideBidAsk(){ SaveData = saveData }, input, ref cachespsInsideBidAsk);
		}

		public SpeculatorSeth.spsInventoryCostBasis spsInventoryCostBasis(ISeries<double> input, bool isCumulative, bool resetOn_Session)
		{
			if (cachespsInventoryCostBasis != null)
				for (int idx = 0; idx < cachespsInventoryCostBasis.Length; idx++)
					if (cachespsInventoryCostBasis[idx].IsCumulative == isCumulative && cachespsInventoryCostBasis[idx].ResetOn_Session == resetOn_Session && cachespsInventoryCostBasis[idx].EqualsInput(input))
						return cachespsInventoryCostBasis[idx];
			return CacheIndicator<SpeculatorSeth.spsInventoryCostBasis>(new SpeculatorSeth.spsInventoryCostBasis(){ IsCumulative = isCumulative, ResetOn_Session = resetOn_Session }, input, ref cachespsInventoryCostBasis);
		}

		public SpeculatorSeth.spsKalman spsKalman(ISeries<double> input, double gain)
		{
			if (cachespsKalman != null)
				for (int idx = 0; idx < cachespsKalman.Length; idx++)
					if (cachespsKalman[idx].Gain == gain && cachespsKalman[idx].EqualsInput(input))
						return cachespsKalman[idx];
			return CacheIndicator<SpeculatorSeth.spsKalman>(new SpeculatorSeth.spsKalman(){ Gain = gain }, input, ref cachespsKalman);
		}

		public SpeculatorSeth.spsLargestRestingOrders spsLargestRestingOrders(ISeries<double> input, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			if (cachespsLargestRestingOrders != null)
				for (int idx = 0; idx < cachespsLargestRestingOrders.Length; idx++)
					if (cachespsLargestRestingOrders[idx].MinFilter == minFilter && cachespsLargestRestingOrders[idx].MaxFilter == maxFilter && cachespsLargestRestingOrders[idx].MinLevelFilter == minLevelFilter && cachespsLargestRestingOrders[idx].MaxLevelFilter == maxLevelFilter && cachespsLargestRestingOrders[idx].ShowBids == showBids && cachespsLargestRestingOrders[idx].ShowOffers == showOffers && cachespsLargestRestingOrders[idx].EqualsInput(input))
						return cachespsLargestRestingOrders[idx];
			return CacheIndicator<SpeculatorSeth.spsLargestRestingOrders>(new SpeculatorSeth.spsLargestRestingOrders(){ MinFilter = minFilter, MaxFilter = maxFilter, MinLevelFilter = minLevelFilter, MaxLevelFilter = maxLevelFilter, ShowBids = showBids, ShowOffers = showOffers }, input, ref cachespsLargestRestingOrders);
		}

		public SpeculatorSeth.spsLevel2Changes spsLevel2Changes(ISeries<double> input, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			if (cachespsLevel2Changes != null)
				for (int idx = 0; idx < cachespsLevel2Changes.Length; idx++)
					if (cachespsLevel2Changes[idx].MinFilter == minFilter && cachespsLevel2Changes[idx].MaxFilter == maxFilter && cachespsLevel2Changes[idx].MinLevelFilter == minLevelFilter && cachespsLevel2Changes[idx].MaxLevelFilter == maxLevelFilter && cachespsLevel2Changes[idx].ShowBids == showBids && cachespsLevel2Changes[idx].ShowOffers == showOffers && cachespsLevel2Changes[idx].EqualsInput(input))
						return cachespsLevel2Changes[idx];
			return CacheIndicator<SpeculatorSeth.spsLevel2Changes>(new SpeculatorSeth.spsLevel2Changes(){ MinFilter = minFilter, MaxFilter = maxFilter, MinLevelFilter = minLevelFilter, MaxLevelFilter = maxLevelFilter, ShowBids = showBids, ShowOffers = showOffers }, input, ref cachespsLevel2Changes);
		}

		public SpeculatorSeth.spsMarketOrderImbalance spsMarketOrderImbalance(ISeries<double> input, int period)
		{
			if (cachespsMarketOrderImbalance != null)
				for (int idx = 0; idx < cachespsMarketOrderImbalance.Length; idx++)
					if (cachespsMarketOrderImbalance[idx].Period == period && cachespsMarketOrderImbalance[idx].EqualsInput(input))
						return cachespsMarketOrderImbalance[idx];
			return CacheIndicator<SpeculatorSeth.spsMarketOrderImbalance>(new SpeculatorSeth.spsMarketOrderImbalance(){ Period = period }, input, ref cachespsMarketOrderImbalance);
		}

		public SpeculatorSeth.spsMultiATR spsMultiATR(ISeries<double> input, int period, RangeType myRangeType)
		{
			if (cachespsMultiATR != null)
				for (int idx = 0; idx < cachespsMultiATR.Length; idx++)
					if (cachespsMultiATR[idx].Period == period && cachespsMultiATR[idx].MyRangeType == myRangeType && cachespsMultiATR[idx].EqualsInput(input))
						return cachespsMultiATR[idx];
			return CacheIndicator<SpeculatorSeth.spsMultiATR>(new SpeculatorSeth.spsMultiATR(){ Period = period, MyRangeType = myRangeType }, input, ref cachespsMultiATR);
		}

		public SpeculatorSeth.spsNewsWarning spsNewsWarning(ISeries<double> input, int beforeHalt, int afterHalt)
		{
			if (cachespsNewsWarning != null)
				for (int idx = 0; idx < cachespsNewsWarning.Length; idx++)
					if (cachespsNewsWarning[idx].BeforeHalt == beforeHalt && cachespsNewsWarning[idx].AfterHalt == afterHalt && cachespsNewsWarning[idx].EqualsInput(input))
						return cachespsNewsWarning[idx];
			return CacheIndicator<SpeculatorSeth.spsNewsWarning>(new SpeculatorSeth.spsNewsWarning(){ BeforeHalt = beforeHalt, AfterHalt = afterHalt }, input, ref cachespsNewsWarning);
		}

		public SpeculatorSeth.spsProjectedRange spsProjectedRange(ISeries<double> input)
		{
			if (cachespsProjectedRange != null)
				for (int idx = 0; idx < cachespsProjectedRange.Length; idx++)
					if ( cachespsProjectedRange[idx].EqualsInput(input))
						return cachespsProjectedRange[idx];
			return CacheIndicator<SpeculatorSeth.spsProjectedRange>(new SpeculatorSeth.spsProjectedRange(), input, ref cachespsProjectedRange);
		}

		public SpeculatorSeth.spsPulledPrices spsPulledPrices(ISeries<double> input, int gap, long size)
		{
			if (cachespsPulledPrices != null)
				for (int idx = 0; idx < cachespsPulledPrices.Length; idx++)
					if (cachespsPulledPrices[idx].Gap == gap && cachespsPulledPrices[idx].Size == size && cachespsPulledPrices[idx].EqualsInput(input))
						return cachespsPulledPrices[idx];
			return CacheIndicator<SpeculatorSeth.spsPulledPrices>(new SpeculatorSeth.spsPulledPrices(){ Gap = gap, Size = size }, input, ref cachespsPulledPrices);
		}

		public SpeculatorSeth.spsRangeHistogram spsRangeHistogram(ISeries<double> input, bool useLog, bool useArea, double valueAreaPercent, bool limitByDayOfWeek, System.DayOfWeek week, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			if (cachespsRangeHistogram != null)
				for (int idx = 0; idx < cachespsRangeHistogram.Length; idx++)
					if (cachespsRangeHistogram[idx].UseLog == useLog && cachespsRangeHistogram[idx].UseArea == useArea && cachespsRangeHistogram[idx].ValueAreaPercent == valueAreaPercent && cachespsRangeHistogram[idx].LimitByDayOfWeek == limitByDayOfWeek && cachespsRangeHistogram[idx].Week == week && cachespsRangeHistogram[idx].NormalColor == normalColor && cachespsRangeHistogram[idx].ValueColor == valueColor && cachespsRangeHistogram[idx].textSize == textSize && cachespsRangeHistogram[idx].TextColor == textColor && cachespsRangeHistogram[idx].EqualsInput(input))
						return cachespsRangeHistogram[idx];
			return CacheIndicator<SpeculatorSeth.spsRangeHistogram>(new SpeculatorSeth.spsRangeHistogram(){ UseLog = useLog, UseArea = useArea, ValueAreaPercent = valueAreaPercent, LimitByDayOfWeek = limitByDayOfWeek, Week = week, NormalColor = normalColor, ValueColor = valueColor, textSize = textSize, TextColor = textColor }, input, ref cachespsRangeHistogram);
		}

		public SpeculatorSeth.spsRestingOrders spsRestingOrders(ISeries<double> input, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			if (cachespsRestingOrders != null)
				for (int idx = 0; idx < cachespsRestingOrders.Length; idx++)
					if (cachespsRestingOrders[idx].MinFilter == minFilter && cachespsRestingOrders[idx].MaxFilter == maxFilter && cachespsRestingOrders[idx].MinLevelFilter == minLevelFilter && cachespsRestingOrders[idx].MaxLevelFilter == maxLevelFilter && cachespsRestingOrders[idx].EqualsInput(input))
						return cachespsRestingOrders[idx];
			return CacheIndicator<SpeculatorSeth.spsRestingOrders>(new SpeculatorSeth.spsRestingOrders(){ MinFilter = minFilter, MaxFilter = maxFilter, MinLevelFilter = minLevelFilter, MaxLevelFilter = maxLevelFilter }, input, ref cachespsRestingOrders);
		}

		public SpeculatorSeth.spsRestingOrdersFiltered spsRestingOrdersFiltered(ISeries<double> input, bool saveData, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			if (cachespsRestingOrdersFiltered != null)
				for (int idx = 0; idx < cachespsRestingOrdersFiltered.Length; idx++)
					if (cachespsRestingOrdersFiltered[idx].SaveData == saveData && cachespsRestingOrdersFiltered[idx].MinFilter == minFilter && cachespsRestingOrdersFiltered[idx].MaxFilter == maxFilter && cachespsRestingOrdersFiltered[idx].MinLevelFilter == minLevelFilter && cachespsRestingOrdersFiltered[idx].MaxLevelFilter == maxLevelFilter && cachespsRestingOrdersFiltered[idx].EqualsInput(input))
						return cachespsRestingOrdersFiltered[idx];
			return CacheIndicator<SpeculatorSeth.spsRestingOrdersFiltered>(new SpeculatorSeth.spsRestingOrdersFiltered(){ SaveData = saveData, MinFilter = minFilter, MaxFilter = maxFilter, MinLevelFilter = minLevelFilter, MaxLevelFilter = maxLevelFilter }, input, ref cachespsRestingOrdersFiltered);
		}

		public SpeculatorSeth.spsScatterPlot spsScatterPlot(ISeries<double> input, int factor, Brush pointColor)
		{
			if (cachespsScatterPlot != null)
				for (int idx = 0; idx < cachespsScatterPlot.Length; idx++)
					if (cachespsScatterPlot[idx].Factor == factor && cachespsScatterPlot[idx].PointColor == pointColor && cachespsScatterPlot[idx].EqualsInput(input))
						return cachespsScatterPlot[idx];
			return CacheIndicator<SpeculatorSeth.spsScatterPlot>(new SpeculatorSeth.spsScatterPlot(){ Factor = factor, PointColor = pointColor }, input, ref cachespsScatterPlot);
		}

		public SpeculatorSeth.spsSessionHighlight spsSessionHighlight(ISeries<double> input, int startHour, int startMinute, int endHour, int endMinute)
		{
			if (cachespsSessionHighlight != null)
				for (int idx = 0; idx < cachespsSessionHighlight.Length; idx++)
					if (cachespsSessionHighlight[idx].StartHour == startHour && cachespsSessionHighlight[idx].StartMinute == startMinute && cachespsSessionHighlight[idx].EndHour == endHour && cachespsSessionHighlight[idx].EndMinute == endMinute && cachespsSessionHighlight[idx].EqualsInput(input))
						return cachespsSessionHighlight[idx];
			return CacheIndicator<SpeculatorSeth.spsSessionHighlight>(new SpeculatorSeth.spsSessionHighlight(){ StartHour = startHour, StartMinute = startMinute, EndHour = endHour, EndMinute = endMinute }, input, ref cachespsSessionHighlight);
		}

		public SpeculatorSeth.spsSpread spsSpread(ISeries<double> input, string leg0, int ratio0, string leg1, int ratio1, string leg2, int ratio2, string leg3, int ratio3, string leg4, int ratio4, bool userProvidesMonth, int number, bool grayHistorical)
		{
			if (cachespsSpread != null)
				for (int idx = 0; idx < cachespsSpread.Length; idx++)
					if (cachespsSpread[idx].Leg0 == leg0 && cachespsSpread[idx].Ratio0 == ratio0 && cachespsSpread[idx].Leg1 == leg1 && cachespsSpread[idx].Ratio1 == ratio1 && cachespsSpread[idx].Leg2 == leg2 && cachespsSpread[idx].Ratio2 == ratio2 && cachespsSpread[idx].Leg3 == leg3 && cachespsSpread[idx].Ratio3 == ratio3 && cachespsSpread[idx].Leg4 == leg4 && cachespsSpread[idx].Ratio4 == ratio4 && cachespsSpread[idx].UserProvidesMonth == userProvidesMonth && cachespsSpread[idx].Number == number && cachespsSpread[idx].GrayHistorical == grayHistorical && cachespsSpread[idx].EqualsInput(input))
						return cachespsSpread[idx];
			return CacheIndicator<SpeculatorSeth.spsSpread>(new SpeculatorSeth.spsSpread(){ Leg0 = leg0, Ratio0 = ratio0, Leg1 = leg1, Ratio1 = ratio1, Leg2 = leg2, Ratio2 = ratio2, Leg3 = leg3, Ratio3 = ratio3, Leg4 = leg4, Ratio4 = ratio4, UserProvidesMonth = userProvidesMonth, Number = number, GrayHistorical = grayHistorical }, input, ref cachespsSpread);
		}

		public SpeculatorSeth.spsVolatilityProjectedRange spsVolatilityProjectedRange(ISeries<double> input)
		{
			if (cachespsVolatilityProjectedRange != null)
				for (int idx = 0; idx < cachespsVolatilityProjectedRange.Length; idx++)
					if ( cachespsVolatilityProjectedRange[idx].EqualsInput(input))
						return cachespsVolatilityProjectedRange[idx];
			return CacheIndicator<SpeculatorSeth.spsVolatilityProjectedRange>(new SpeculatorSeth.spsVolatilityProjectedRange(), input, ref cachespsVolatilityProjectedRange);
		}

		public SpeculatorSeth.spsVWAP spsVWAP(ISeries<double> input, SpsTimeframe resetDeltaOn)
		{
			if (cachespsVWAP != null)
				for (int idx = 0; idx < cachespsVWAP.Length; idx++)
					if (cachespsVWAP[idx].ResetDeltaOn == resetDeltaOn && cachespsVWAP[idx].EqualsInput(input))
						return cachespsVWAP[idx];
			return CacheIndicator<SpeculatorSeth.spsVWAP>(new SpeculatorSeth.spsVWAP(){ ResetDeltaOn = resetDeltaOn }, input, ref cachespsVWAP);
		}

		public SpeculatorSeth.spsYieldCurve spsYieldCurve(ISeries<double> input, string expiry)
		{
			if (cachespsYieldCurve != null)
				for (int idx = 0; idx < cachespsYieldCurve.Length; idx++)
					if (cachespsYieldCurve[idx].Expiry == expiry && cachespsYieldCurve[idx].EqualsInput(input))
						return cachespsYieldCurve[idx];
			return CacheIndicator<SpeculatorSeth.spsYieldCurve>(new SpeculatorSeth.spsYieldCurve(){ Expiry = expiry }, input, ref cachespsYieldCurve);
		}

		public SpeculatorSethFree.spsRangeHistogramFree spsRangeHistogramFree(ISeries<double> input, double valueAreaPercent, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			if (cachespsRangeHistogramFree != null)
				for (int idx = 0; idx < cachespsRangeHistogramFree.Length; idx++)
					if (cachespsRangeHistogramFree[idx].ValueAreaPercent == valueAreaPercent && cachespsRangeHistogramFree[idx].NormalColor == normalColor && cachespsRangeHistogramFree[idx].ValueColor == valueColor && cachespsRangeHistogramFree[idx].textSize == textSize && cachespsRangeHistogramFree[idx].TextColor == textColor && cachespsRangeHistogramFree[idx].EqualsInput(input))
						return cachespsRangeHistogramFree[idx];
			return CacheIndicator<SpeculatorSethFree.spsRangeHistogramFree>(new SpeculatorSethFree.spsRangeHistogramFree(){ ValueAreaPercent = valueAreaPercent, NormalColor = normalColor, ValueColor = valueColor, textSize = textSize, TextColor = textColor }, input, ref cachespsRangeHistogramFree);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.SpeculatorSeth.spsAdvCumulativeDelta spsAdvCumulativeDelta(SpSTimeframe resetDeltaOn)
		{
			return indicator.spsAdvCumulativeDelta(Input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsAlice spsAlice(int period, double target)
		{
			return indicator.spsAlice(Input, period, target);
		}

		public Indicators.SpeculatorSeth.spsCumulativeDelta spsCumulativeDelta(SpsTimeframe resetDeltaOn)
		{
			return indicator.spsCumulativeDelta(Input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsDataPipe spsDataPipe(int startHour, int startMinute, int endHour, int endMinute, bool outputMarketDepth, bool outputMarketData)
		{
			return indicator.spsDataPipe(Input, startHour, startMinute, endHour, endMinute, outputMarketDepth, outputMarketData);
		}

		public Indicators.SpeculatorSeth.spsDelta spsDelta()
		{
			return indicator.spsDelta(Input);
		}

		public Indicators.SpeculatorSeth.spsFairValueGap spsFairValueGap(double gap, int dailyATRPeriod)
		{
			return indicator.spsFairValueGap(Input, gap, dailyATRPeriod);
		}

		public Indicators.SpeculatorSeth.spsInsideBidAsk spsInsideBidAsk(bool saveData)
		{
			return indicator.spsInsideBidAsk(Input, saveData);
		}

		public Indicators.SpeculatorSeth.spsInventoryCostBasis spsInventoryCostBasis(bool isCumulative, bool resetOn_Session)
		{
			return indicator.spsInventoryCostBasis(Input, isCumulative, resetOn_Session);
		}

		public Indicators.SpeculatorSeth.spsKalman spsKalman(double gain)
		{
			return indicator.spsKalman(Input, gain);
		}

		public Indicators.SpeculatorSeth.spsLargestRestingOrders spsLargestRestingOrders(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLargestRestingOrders(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsLevel2Changes spsLevel2Changes(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLevel2Changes(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsMarketOrderImbalance spsMarketOrderImbalance(int period)
		{
			return indicator.spsMarketOrderImbalance(Input, period);
		}

		public Indicators.SpeculatorSeth.spsMultiATR spsMultiATR(int period, RangeType myRangeType)
		{
			return indicator.spsMultiATR(Input, period, myRangeType);
		}

		public Indicators.SpeculatorSeth.spsNewsWarning spsNewsWarning(int beforeHalt, int afterHalt)
		{
			return indicator.spsNewsWarning(Input, beforeHalt, afterHalt);
		}

		public Indicators.SpeculatorSeth.spsProjectedRange spsProjectedRange()
		{
			return indicator.spsProjectedRange(Input);
		}

		public Indicators.SpeculatorSeth.spsPulledPrices spsPulledPrices(int gap, long size)
		{
			return indicator.spsPulledPrices(Input, gap, size);
		}

		public Indicators.SpeculatorSeth.spsRangeHistogram spsRangeHistogram(bool useLog, bool useArea, double valueAreaPercent, bool limitByDayOfWeek, System.DayOfWeek week, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogram(Input, useLog, useArea, valueAreaPercent, limitByDayOfWeek, week, normalColor, valueColor, textSize, textColor);
		}

		public Indicators.SpeculatorSeth.spsRestingOrders spsRestingOrders(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrders(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsRestingOrdersFiltered spsRestingOrdersFiltered(bool saveData, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrdersFiltered(Input, saveData, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsScatterPlot spsScatterPlot(int factor, Brush pointColor)
		{
			return indicator.spsScatterPlot(Input, factor, pointColor);
		}

		public Indicators.SpeculatorSeth.spsSessionHighlight spsSessionHighlight(int startHour, int startMinute, int endHour, int endMinute)
		{
			return indicator.spsSessionHighlight(Input, startHour, startMinute, endHour, endMinute);
		}

		public Indicators.SpeculatorSeth.spsSpread spsSpread(string leg0, int ratio0, string leg1, int ratio1, string leg2, int ratio2, string leg3, int ratio3, string leg4, int ratio4, bool userProvidesMonth, int number, bool grayHistorical)
		{
			return indicator.spsSpread(Input, leg0, ratio0, leg1, ratio1, leg2, ratio2, leg3, ratio3, leg4, ratio4, userProvidesMonth, number, grayHistorical);
		}

		public Indicators.SpeculatorSeth.spsVolatilityProjectedRange spsVolatilityProjectedRange()
		{
			return indicator.spsVolatilityProjectedRange(Input);
		}

		public Indicators.SpeculatorSeth.spsVWAP spsVWAP(SpsTimeframe resetDeltaOn)
		{
			return indicator.spsVWAP(Input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsYieldCurve spsYieldCurve(string expiry)
		{
			return indicator.spsYieldCurve(Input, expiry);
		}

		public Indicators.SpeculatorSethFree.spsRangeHistogramFree spsRangeHistogramFree(double valueAreaPercent, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogramFree(Input, valueAreaPercent, normalColor, valueColor, textSize, textColor);
		}


		
		public Indicators.SpeculatorSeth.spsAdvCumulativeDelta spsAdvCumulativeDelta(ISeries<double> input , SpSTimeframe resetDeltaOn)
		{
			return indicator.spsAdvCumulativeDelta(input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsAlice spsAlice(ISeries<double> input , int period, double target)
		{
			return indicator.spsAlice(input, period, target);
		}

		public Indicators.SpeculatorSeth.spsCumulativeDelta spsCumulativeDelta(ISeries<double> input , SpsTimeframe resetDeltaOn)
		{
			return indicator.spsCumulativeDelta(input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsDataPipe spsDataPipe(ISeries<double> input , int startHour, int startMinute, int endHour, int endMinute, bool outputMarketDepth, bool outputMarketData)
		{
			return indicator.spsDataPipe(input, startHour, startMinute, endHour, endMinute, outputMarketDepth, outputMarketData);
		}

		public Indicators.SpeculatorSeth.spsDelta spsDelta(ISeries<double> input )
		{
			return indicator.spsDelta(input);
		}

		public Indicators.SpeculatorSeth.spsFairValueGap spsFairValueGap(ISeries<double> input , double gap, int dailyATRPeriod)
		{
			return indicator.spsFairValueGap(input, gap, dailyATRPeriod);
		}

		public Indicators.SpeculatorSeth.spsInsideBidAsk spsInsideBidAsk(ISeries<double> input , bool saveData)
		{
			return indicator.spsInsideBidAsk(input, saveData);
		}

		public Indicators.SpeculatorSeth.spsInventoryCostBasis spsInventoryCostBasis(ISeries<double> input , bool isCumulative, bool resetOn_Session)
		{
			return indicator.spsInventoryCostBasis(input, isCumulative, resetOn_Session);
		}

		public Indicators.SpeculatorSeth.spsKalman spsKalman(ISeries<double> input , double gain)
		{
			return indicator.spsKalman(input, gain);
		}

		public Indicators.SpeculatorSeth.spsLargestRestingOrders spsLargestRestingOrders(ISeries<double> input , int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLargestRestingOrders(input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsLevel2Changes spsLevel2Changes(ISeries<double> input , int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLevel2Changes(input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsMarketOrderImbalance spsMarketOrderImbalance(ISeries<double> input , int period)
		{
			return indicator.spsMarketOrderImbalance(input, period);
		}

		public Indicators.SpeculatorSeth.spsMultiATR spsMultiATR(ISeries<double> input , int period, RangeType myRangeType)
		{
			return indicator.spsMultiATR(input, period, myRangeType);
		}

		public Indicators.SpeculatorSeth.spsNewsWarning spsNewsWarning(ISeries<double> input , int beforeHalt, int afterHalt)
		{
			return indicator.spsNewsWarning(input, beforeHalt, afterHalt);
		}

		public Indicators.SpeculatorSeth.spsProjectedRange spsProjectedRange(ISeries<double> input )
		{
			return indicator.spsProjectedRange(input);
		}

		public Indicators.SpeculatorSeth.spsPulledPrices spsPulledPrices(ISeries<double> input , int gap, long size)
		{
			return indicator.spsPulledPrices(input, gap, size);
		}

		public Indicators.SpeculatorSeth.spsRangeHistogram spsRangeHistogram(ISeries<double> input , bool useLog, bool useArea, double valueAreaPercent, bool limitByDayOfWeek, System.DayOfWeek week, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogram(input, useLog, useArea, valueAreaPercent, limitByDayOfWeek, week, normalColor, valueColor, textSize, textColor);
		}

		public Indicators.SpeculatorSeth.spsRestingOrders spsRestingOrders(ISeries<double> input , int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrders(input, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsRestingOrdersFiltered spsRestingOrdersFiltered(ISeries<double> input , bool saveData, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrdersFiltered(input, saveData, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsScatterPlot spsScatterPlot(ISeries<double> input , int factor, Brush pointColor)
		{
			return indicator.spsScatterPlot(input, factor, pointColor);
		}

		public Indicators.SpeculatorSeth.spsSessionHighlight spsSessionHighlight(ISeries<double> input , int startHour, int startMinute, int endHour, int endMinute)
		{
			return indicator.spsSessionHighlight(input, startHour, startMinute, endHour, endMinute);
		}

		public Indicators.SpeculatorSeth.spsSpread spsSpread(ISeries<double> input , string leg0, int ratio0, string leg1, int ratio1, string leg2, int ratio2, string leg3, int ratio3, string leg4, int ratio4, bool userProvidesMonth, int number, bool grayHistorical)
		{
			return indicator.spsSpread(input, leg0, ratio0, leg1, ratio1, leg2, ratio2, leg3, ratio3, leg4, ratio4, userProvidesMonth, number, grayHistorical);
		}

		public Indicators.SpeculatorSeth.spsVolatilityProjectedRange spsVolatilityProjectedRange(ISeries<double> input )
		{
			return indicator.spsVolatilityProjectedRange(input);
		}

		public Indicators.SpeculatorSeth.spsVWAP spsVWAP(ISeries<double> input , SpsTimeframe resetDeltaOn)
		{
			return indicator.spsVWAP(input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsYieldCurve spsYieldCurve(ISeries<double> input , string expiry)
		{
			return indicator.spsYieldCurve(input, expiry);
		}

		public Indicators.SpeculatorSethFree.spsRangeHistogramFree spsRangeHistogramFree(ISeries<double> input , double valueAreaPercent, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogramFree(input, valueAreaPercent, normalColor, valueColor, textSize, textColor);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.SpeculatorSeth.spsAdvCumulativeDelta spsAdvCumulativeDelta(SpSTimeframe resetDeltaOn)
		{
			return indicator.spsAdvCumulativeDelta(Input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsAlice spsAlice(int period, double target)
		{
			return indicator.spsAlice(Input, period, target);
		}

		public Indicators.SpeculatorSeth.spsCumulativeDelta spsCumulativeDelta(SpsTimeframe resetDeltaOn)
		{
			return indicator.spsCumulativeDelta(Input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsDataPipe spsDataPipe(int startHour, int startMinute, int endHour, int endMinute, bool outputMarketDepth, bool outputMarketData)
		{
			return indicator.spsDataPipe(Input, startHour, startMinute, endHour, endMinute, outputMarketDepth, outputMarketData);
		}

		public Indicators.SpeculatorSeth.spsDelta spsDelta()
		{
			return indicator.spsDelta(Input);
		}

		public Indicators.SpeculatorSeth.spsFairValueGap spsFairValueGap(double gap, int dailyATRPeriod)
		{
			return indicator.spsFairValueGap(Input, gap, dailyATRPeriod);
		}

		public Indicators.SpeculatorSeth.spsInsideBidAsk spsInsideBidAsk(bool saveData)
		{
			return indicator.spsInsideBidAsk(Input, saveData);
		}

		public Indicators.SpeculatorSeth.spsInventoryCostBasis spsInventoryCostBasis(bool isCumulative, bool resetOn_Session)
		{
			return indicator.spsInventoryCostBasis(Input, isCumulative, resetOn_Session);
		}

		public Indicators.SpeculatorSeth.spsKalman spsKalman(double gain)
		{
			return indicator.spsKalman(Input, gain);
		}

		public Indicators.SpeculatorSeth.spsLargestRestingOrders spsLargestRestingOrders(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLargestRestingOrders(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsLevel2Changes spsLevel2Changes(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLevel2Changes(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsMarketOrderImbalance spsMarketOrderImbalance(int period)
		{
			return indicator.spsMarketOrderImbalance(Input, period);
		}

		public Indicators.SpeculatorSeth.spsMultiATR spsMultiATR(int period, RangeType myRangeType)
		{
			return indicator.spsMultiATR(Input, period, myRangeType);
		}

		public Indicators.SpeculatorSeth.spsNewsWarning spsNewsWarning(int beforeHalt, int afterHalt)
		{
			return indicator.spsNewsWarning(Input, beforeHalt, afterHalt);
		}

		public Indicators.SpeculatorSeth.spsProjectedRange spsProjectedRange()
		{
			return indicator.spsProjectedRange(Input);
		}

		public Indicators.SpeculatorSeth.spsPulledPrices spsPulledPrices(int gap, long size)
		{
			return indicator.spsPulledPrices(Input, gap, size);
		}

		public Indicators.SpeculatorSeth.spsRangeHistogram spsRangeHistogram(bool useLog, bool useArea, double valueAreaPercent, bool limitByDayOfWeek, System.DayOfWeek week, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogram(Input, useLog, useArea, valueAreaPercent, limitByDayOfWeek, week, normalColor, valueColor, textSize, textColor);
		}

		public Indicators.SpeculatorSeth.spsRestingOrders spsRestingOrders(int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrders(Input, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsRestingOrdersFiltered spsRestingOrdersFiltered(bool saveData, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrdersFiltered(Input, saveData, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsScatterPlot spsScatterPlot(int factor, Brush pointColor)
		{
			return indicator.spsScatterPlot(Input, factor, pointColor);
		}

		public Indicators.SpeculatorSeth.spsSessionHighlight spsSessionHighlight(int startHour, int startMinute, int endHour, int endMinute)
		{
			return indicator.spsSessionHighlight(Input, startHour, startMinute, endHour, endMinute);
		}

		public Indicators.SpeculatorSeth.spsSpread spsSpread(string leg0, int ratio0, string leg1, int ratio1, string leg2, int ratio2, string leg3, int ratio3, string leg4, int ratio4, bool userProvidesMonth, int number, bool grayHistorical)
		{
			return indicator.spsSpread(Input, leg0, ratio0, leg1, ratio1, leg2, ratio2, leg3, ratio3, leg4, ratio4, userProvidesMonth, number, grayHistorical);
		}

		public Indicators.SpeculatorSeth.spsVolatilityProjectedRange spsVolatilityProjectedRange()
		{
			return indicator.spsVolatilityProjectedRange(Input);
		}

		public Indicators.SpeculatorSeth.spsVWAP spsVWAP(SpsTimeframe resetDeltaOn)
		{
			return indicator.spsVWAP(Input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsYieldCurve spsYieldCurve(string expiry)
		{
			return indicator.spsYieldCurve(Input, expiry);
		}

		public Indicators.SpeculatorSethFree.spsRangeHistogramFree spsRangeHistogramFree(double valueAreaPercent, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogramFree(Input, valueAreaPercent, normalColor, valueColor, textSize, textColor);
		}


		
		public Indicators.SpeculatorSeth.spsAdvCumulativeDelta spsAdvCumulativeDelta(ISeries<double> input , SpSTimeframe resetDeltaOn)
		{
			return indicator.spsAdvCumulativeDelta(input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsAlice spsAlice(ISeries<double> input , int period, double target)
		{
			return indicator.spsAlice(input, period, target);
		}

		public Indicators.SpeculatorSeth.spsCumulativeDelta spsCumulativeDelta(ISeries<double> input , SpsTimeframe resetDeltaOn)
		{
			return indicator.spsCumulativeDelta(input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsDataPipe spsDataPipe(ISeries<double> input , int startHour, int startMinute, int endHour, int endMinute, bool outputMarketDepth, bool outputMarketData)
		{
			return indicator.spsDataPipe(input, startHour, startMinute, endHour, endMinute, outputMarketDepth, outputMarketData);
		}

		public Indicators.SpeculatorSeth.spsDelta spsDelta(ISeries<double> input )
		{
			return indicator.spsDelta(input);
		}

		public Indicators.SpeculatorSeth.spsFairValueGap spsFairValueGap(ISeries<double> input , double gap, int dailyATRPeriod)
		{
			return indicator.spsFairValueGap(input, gap, dailyATRPeriod);
		}

		public Indicators.SpeculatorSeth.spsInsideBidAsk spsInsideBidAsk(ISeries<double> input , bool saveData)
		{
			return indicator.spsInsideBidAsk(input, saveData);
		}

		public Indicators.SpeculatorSeth.spsInventoryCostBasis spsInventoryCostBasis(ISeries<double> input , bool isCumulative, bool resetOn_Session)
		{
			return indicator.spsInventoryCostBasis(input, isCumulative, resetOn_Session);
		}

		public Indicators.SpeculatorSeth.spsKalman spsKalman(ISeries<double> input , double gain)
		{
			return indicator.spsKalman(input, gain);
		}

		public Indicators.SpeculatorSeth.spsLargestRestingOrders spsLargestRestingOrders(ISeries<double> input , int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLargestRestingOrders(input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsLevel2Changes spsLevel2Changes(ISeries<double> input , int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter, bool showBids, bool showOffers)
		{
			return indicator.spsLevel2Changes(input, minFilter, maxFilter, minLevelFilter, maxLevelFilter, showBids, showOffers);
		}

		public Indicators.SpeculatorSeth.spsMarketOrderImbalance spsMarketOrderImbalance(ISeries<double> input , int period)
		{
			return indicator.spsMarketOrderImbalance(input, period);
		}

		public Indicators.SpeculatorSeth.spsMultiATR spsMultiATR(ISeries<double> input , int period, RangeType myRangeType)
		{
			return indicator.spsMultiATR(input, period, myRangeType);
		}

		public Indicators.SpeculatorSeth.spsNewsWarning spsNewsWarning(ISeries<double> input , int beforeHalt, int afterHalt)
		{
			return indicator.spsNewsWarning(input, beforeHalt, afterHalt);
		}

		public Indicators.SpeculatorSeth.spsProjectedRange spsProjectedRange(ISeries<double> input )
		{
			return indicator.spsProjectedRange(input);
		}

		public Indicators.SpeculatorSeth.spsPulledPrices spsPulledPrices(ISeries<double> input , int gap, long size)
		{
			return indicator.spsPulledPrices(input, gap, size);
		}

		public Indicators.SpeculatorSeth.spsRangeHistogram spsRangeHistogram(ISeries<double> input , bool useLog, bool useArea, double valueAreaPercent, bool limitByDayOfWeek, System.DayOfWeek week, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogram(input, useLog, useArea, valueAreaPercent, limitByDayOfWeek, week, normalColor, valueColor, textSize, textColor);
		}

		public Indicators.SpeculatorSeth.spsRestingOrders spsRestingOrders(ISeries<double> input , int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrders(input, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsRestingOrdersFiltered spsRestingOrdersFiltered(ISeries<double> input , bool saveData, int minFilter, int maxFilter, int minLevelFilter, int maxLevelFilter)
		{
			return indicator.spsRestingOrdersFiltered(input, saveData, minFilter, maxFilter, minLevelFilter, maxLevelFilter);
		}

		public Indicators.SpeculatorSeth.spsScatterPlot spsScatterPlot(ISeries<double> input , int factor, Brush pointColor)
		{
			return indicator.spsScatterPlot(input, factor, pointColor);
		}

		public Indicators.SpeculatorSeth.spsSessionHighlight spsSessionHighlight(ISeries<double> input , int startHour, int startMinute, int endHour, int endMinute)
		{
			return indicator.spsSessionHighlight(input, startHour, startMinute, endHour, endMinute);
		}

		public Indicators.SpeculatorSeth.spsSpread spsSpread(ISeries<double> input , string leg0, int ratio0, string leg1, int ratio1, string leg2, int ratio2, string leg3, int ratio3, string leg4, int ratio4, bool userProvidesMonth, int number, bool grayHistorical)
		{
			return indicator.spsSpread(input, leg0, ratio0, leg1, ratio1, leg2, ratio2, leg3, ratio3, leg4, ratio4, userProvidesMonth, number, grayHistorical);
		}

		public Indicators.SpeculatorSeth.spsVolatilityProjectedRange spsVolatilityProjectedRange(ISeries<double> input )
		{
			return indicator.spsVolatilityProjectedRange(input);
		}

		public Indicators.SpeculatorSeth.spsVWAP spsVWAP(ISeries<double> input , SpsTimeframe resetDeltaOn)
		{
			return indicator.spsVWAP(input, resetDeltaOn);
		}

		public Indicators.SpeculatorSeth.spsYieldCurve spsYieldCurve(ISeries<double> input , string expiry)
		{
			return indicator.spsYieldCurve(input, expiry);
		}

		public Indicators.SpeculatorSethFree.spsRangeHistogramFree spsRangeHistogramFree(ISeries<double> input , double valueAreaPercent, Brush normalColor, Brush valueColor, int textSize, Brush textColor)
		{
			return indicator.spsRangeHistogramFree(input, valueAreaPercent, normalColor, valueColor, textSize, textColor);
		}

	}
}

#endregion
